/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.io.preferences;

import com.aptana.core.logging.IdeLog;
import com.aptana.ide.core.io.CoreIOPlugin;
import com.aptana.ide.core.io.preferences.PermissionDirection;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;

public class PreferenceUtils {
    public static boolean getUpdatePermissions(PermissionDirection direction) {
        switch (direction) {
            case UPLOAD: {
                return Platform.getPreferencesService().getBoolean("com.aptana.core.io", "UploadUpdatePermissions", true, null);
            }
            case DOWNLOAD: {
                return Platform.getPreferencesService().getBoolean("com.aptana.core.io", "DownloadUpdatePermissions", true, null);
            }
        }
        return true;
    }

    public static boolean getSpecificPermissions(PermissionDirection direction) {
        switch (direction) {
            case UPLOAD: {
                return Platform.getPreferencesService().getBoolean("com.aptana.core.io", "UploadSpecificPermissions", true, null);
            }
            case DOWNLOAD: {
                return Platform.getPreferencesService().getBoolean("com.aptana.core.io", "DownloadSpecificPermissions", true, null);
            }
        }
        return true;
    }

    public static long getFilePermissions(PermissionDirection direction) {
        switch (direction) {
            case UPLOAD: {
                return Platform.getPreferencesService().getLong("com.aptana.core.io", "FilePermission", 438L, null);
            }
            case DOWNLOAD: {
                return Platform.getPreferencesService().getLong("com.aptana.core.io", "DownloadFilePermission", 438L, null);
            }
        }
        return 438L;
    }

    public static long getFolderPermissions(PermissionDirection direction) {
        switch (direction) {
            case UPLOAD: {
                return Platform.getPreferencesService().getLong("com.aptana.core.io", "DirectoryPermission", 511L, null);
            }
            case DOWNLOAD: {
                return Platform.getPreferencesService().getLong("com.aptana.core.io", "DownloadDirectoryPermission", 511L, null);
            }
        }
        return 511L;
    }

    public static void setUpdatePermissions(boolean shouldUpdate, PermissionDirection direction) {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("com.aptana.core.io");
        switch (direction) {
            case UPLOAD: {
                prefs.putBoolean("UploadUpdatePermissions", shouldUpdate);
                break;
            }
            case DOWNLOAD: {
                prefs.putBoolean("DownloadUpdatePermissions", shouldUpdate);
            }
        }
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            IdeLog.logError((Plugin)CoreIOPlugin.getDefault(), (Throwable)e);
        }
    }

    public static void setSpecificPermissions(boolean shouldSpecific, PermissionDirection direction) {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("com.aptana.core.io");
        switch (direction) {
            case UPLOAD: {
                prefs.putBoolean("UploadSpecificPermissions", shouldSpecific);
                break;
            }
            case DOWNLOAD: {
                prefs.putBoolean("DownloadSpecificPermissions", shouldSpecific);
            }
        }
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            IdeLog.logError((Plugin)CoreIOPlugin.getDefault(), (Throwable)e);
        }
    }

    public static void setFilePermissions(long permissions, PermissionDirection direction) {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("com.aptana.core.io");
        switch (direction) {
            case UPLOAD: {
                prefs.putLong("FilePermission", permissions);
                break;
            }
            case DOWNLOAD: {
                prefs.putLong("DownloadFilePermission", permissions);
            }
        }
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            IdeLog.logError((Plugin)CoreIOPlugin.getDefault(), (Throwable)e);
        }
    }

    public static void setFolderPermissions(long permissions, PermissionDirection direction) {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("com.aptana.core.io");
        switch (direction) {
            case UPLOAD: {
                prefs.putLong("DirectoryPermission", permissions);
                break;
            }
            case DOWNLOAD: {
                prefs.putLong("DownloadDirectoryPermission", permissions);
            }
        }
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            IdeLog.logError((Plugin)CoreIOPlugin.getDefault(), (Throwable)e);
        }
    }
}

